<?php



/**
 * Frontend Subscriber Functions
 *
 * Handles email subscription form submissions from visitor-facing pages
 * @package SeedProd
 */

/**
 * Frontend Subscribe Callback Handler
 *
 * Processes email subscription form submissions from visitor-facing pages
 * (coming soon pages, landing pages, etc.)
 *
 * This function is registered via AJAX hooks in routes.php:
 * - wp_ajax_seedprod_pro_subscribe_callback
 * - wp_ajax_nopriv_seedprod_pro_subscribe_callback
 */
function seedprod_pro_subscribe_callback() {
	// get request data

	$email = '';
	if ( ! empty( $_POST['email'] ) ) { // phpcs:ignore WordPress.Security.NonceVerification.Missing
		$email = sanitize_email( wp_unslash( $_POST['email'] ) ); // phpcs:ignore WordPress.Security.NonceVerification.Missing
	}

	if ( empty( $email ) ) {
		wp_send_json_error();
	}

	$page_uuid = '';
	if ( ! empty( $_POST['page_uuid'] ) ) { // phpcs:ignore WordPress.Security.NonceVerification.Missing
		$page_uuid = sanitize_text_field( wp_unslash( $_POST['page_uuid'] ) ); // phpcs:ignore WordPress.Security.NonceVerification.Missing
	}

	$page_id = '';
	if ( ! empty( $_POST['page_id'] ) ) { // phpcs:ignore WordPress.Security.NonceVerification.Missing
		$page_id = absint( $_POST['page_id'] ); // phpcs:ignore WordPress.Security.NonceVerification.Missing
	}

	$name = '';
	if ( ! empty( $_REQUEST['name'] ) ) { // phpcs:ignore WordPress.Security.NonceVerification.Recommended
		$name = sanitize_text_field( wp_unslash( $_REQUEST['name'] ) ); // phpcs:ignore WordPress.Security.NonceVerification.Recommended
	}

	$fname = '';
	$lname = '';

	if ( ! empty( $name ) ) {
		require_once SEEDPROD_PRO_PLUGIN_PATH . 'app/includes/nameparse.php';
		$name  = seedprod_pro_parse_name( $name );
		$fname = $name['first'];
		$lname = $name['last'];
	}

	$optin_confirmation = 0;
	if ( ! empty( $_REQUEST['optin_confirmation'] ) ) { // phpcs:ignore WordPress.Security.NonceVerification.Recommended
		$optin_confirmation = 1;
	}

	// Record user in DB if they do not exist
	global $wpdb;
	$tablename     = $wpdb->prefix . 'csp3_subscribers';
	$sql           = "SELECT * FROM $tablename WHERE email = %s AND page_uuid = %s";
	$safe_sql      = $wpdb->prepare( $sql, $email, $page_uuid ); // phpcs:ignore WordPress.DB.PreparedSQL.NotPrepared
	$select_result = $wpdb->get_row( $safe_sql ); // phpcs:ignore WordPress.DB.PreparedSQL.NotPrepared

	if ( empty( $select_result->email ) ) {
		$values        = array(
			'email'         => $email,
			'page_id'       => $page_id,
			'page_uuid'     => $page_uuid,
			'ip'            => seedprod_pro_get_ip(),
			'fname'         => $fname,
			'lname'         => $lname,
			'optin_confirm' => $optin_confirmation,
		);
		$format_values = array(
			'%s',
			'%d',
			'%s',
			'%s',
			'%s',
			'%s',
			'%d',
		);
		$insert_result = $wpdb->insert(
			$tablename,
			$values,
			$format_values
		);
		// run a do_action to allow other to hook into
		do_action( 'seedprod_add_subscriber', $values );
	}

	wp_send_json_success();
}


