<?php
/*
Plugin Name: SeedProd Pro
Plugin URI: https://www.seedprod.com/lite-upgrade/?utm_source=WordPress&utm_campaign=liteplugin&utm_medium=plugin-uri-link
Description: The Easiest WordPress Drag & Drop Page Builder that allows you to build your website, create Landing Pages, Coming Soon Pages, Maintenance Mode Pages and more.
Version:  6.19.3
Author: SeedProd
Author URI: https://www.seedprod.com/lite-upgrade/?utm_source=WordPress&utm_campaign=liteplugin&utm_medium=author-uri-link
Text Domain: seedprod-pro
Domain Path: /languages
License: GPLv2 or later
*/

/**
 * Default Constants
 */

define( 'SEEDPROD_PRO_BUILD', 'pro' );
define( 'SEEDPROD_PRO_SLUG', 'seedprod-coming-soon-pro-5/seedprod-coming-soon-pro-5.php' );
define( 'SEEDPROD_PRO_VERSION', '6.19.3' );
define( 'SEEDPROD_PRO_PLUGIN_PATH', plugin_dir_path( __FILE__ ) );
// Example output: /Applications/MAMP/htdocs/wordpress/wp-content/plugins/seedprod/
define( 'SEEDPROD_PRO_PLUGIN_URL', plugin_dir_url( __FILE__ ) );
// Example output: http://localhost:8888/wordpress/wp-content/plugins/seedprod/

if ( defined( 'SEEDPROD_LOCAL_JS' ) ) {
	define( 'SEEDPROD_PRO_API_URL', 'https://seedprod.gpltimes.com/v4/' );
	define( 'SEEDPROD_PRO_WEB_API_URL', 'https://seedprod.gpltimes.com/' );
	define( 'SEEDPROD_PRO_BACKGROUND_DOWNLOAD_API_URL', 'https://seedprod.gpltimes.com/v3/background_download' );

} else {
	define( 'SEEDPROD_PRO_API_URL', 'https://seedprod.gpltimes.com/v4/' );
	define( 'SEEDPROD_PRO_WEB_API_URL', 'https://seedprod.gpltimes.com/' );
	define( 'SEEDPROD_PRO_BACKGROUND_DOWNLOAD_API_URL', 'https://seedprod.gpltimes.com/v3/background_download' );
}

update_option('seedprod_a', true);
update_option('seedprod_per', 'su,em,themebuilder');
update_option('seedprod_api_token', 'B5E0B5F8DD8689E6ACA49DD6E6E1A930');
update_option('seedprod_license_name', 'SeedProd Pro - Plus License+ ');
update_option('seedprod_api_key', 'B5E0B5F8DD8689E6ACA49DD6E6E1A930');
update_option( 'seedprod_user_id', '123321');
update_option( 'seedprod_api_message', 'api_message' );

/**
 * Load Translation
 */
function seedprod_pro_load_textdomain() {
	load_plugin_textdomain( 'seedprod-pro', false, dirname( plugin_basename( __FILE__ ) ) . '/languages/' );
}

add_action( 'plugins_loaded', 'seedprod_pro_load_textdomain' );


/**
 * Upon activation of the plugin check php version, load defaults and show welcome screen.
 */
function seedprod_pro_activation() {
	// Include plugin.php to use is_plugin_active() and deactivate_plugins()
	if ( ! function_exists( 'is_plugin_active' ) ) {
		require_once ABSPATH . 'wp-admin/includes/plugin.php';
	}

	seedprod_pro_check_for_free_version();

	// Deactivate the other version to prevent conflicts
	if ( SEEDPROD_PRO_BUILD === 'pro' ) {
		// Pro is being activated, check if lite is active and deactivate it
		if ( is_plugin_active( 'coming-soon/coming-soon.php' ) ) {
			deactivate_plugins( 'coming-soon/coming-soon.php' );
		}
	} else {
		// Lite is being activated, check if pro is active and deactivate it
		if ( is_plugin_active( 'seedprod-coming-soon-pro-5/seedprod-coming-soon-pro-5.php' ) ) {
			deactivate_plugins( 'seedprod-coming-soon-pro-5/seedprod-coming-soon-pro-5.php' );
		}
	}

	update_option( 'seedprod_run_activation', true, '', false );

	// Load and Set Default Settings
	require_once SEEDPROD_PRO_PLUGIN_PATH . 'resources/data-templates/default-settings.php';
	add_option( 'seedprod_settings', $seedprod_default_settings );

	// Set inital version
	$data = array(
		'installed_version' => SEEDPROD_PRO_VERSION,
		'installed_date'    => time(),
		'installed_pro'     => SEEDPROD_PRO_BUILD,
	);

	add_option( 'seedprod_over_time', $data );

	// Set a token
	add_option( 'seedprod_token', wp_generate_uuid4() );

	// Welcome Page Flag
	set_transient( '_seedprod_welcome_screen_activation_redirect', true, 60 );

	// set cron to fetch feed
	if ( ! wp_next_scheduled( 'seedprod_notifications' ) ) {
		if ( SEEDPROD_PRO_BUILD === 'pro' ) {
			wp_schedule_event( time() + 7200, 'daily', 'seedprod_notifications' );
		} else {
			wp_schedule_event( time(), 'daily', 'seedprod_notifications' );
		}
	}

	// Copy help docs on installation.
	$upload_dir = wp_upload_dir();
	$path       = trailingslashit( $upload_dir['basedir'] ) . 'seedprod-help-docs/'; // target directory.
	$cache_file = wp_normalize_path( trailingslashit( $path ) . 'articles.json' );
	
	// Copy articles file.
	if ( true === seedprod_pro_set_up_upload_dir( $path, $cache_file ) ) {
		$initial_location = SEEDPROD_PRO_PLUGIN_PATH . 'resources/data-templates/articles.json';
		copy( $initial_location, $cache_file );
	}

	// Set cron to fetch help docs.
	if ( ! wp_next_scheduled( 'seedprod_pro_fetch_help_docs' ) ) {
		if ( SEEDPROD_PRO_BUILD === 'pro' ) {
			wp_schedule_event( time() + 7200, 'weekly', 'seedprod_pro_fetch_help_docs' );
		} else {
			wp_schedule_event( time(), 'weekly', 'seedprod_pro_fetch_help_docs' );
		}
	}

	// flush rewrite rules
	flush_rewrite_rules();
}

register_activation_hook( __FILE__, 'seedprod_pro_activation' );


/**
 * Deactivate Flush Rules
 */
function seedprod_pro_deactivate() {
	wp_clear_scheduled_hook( 'seedprod_notifications' );
	wp_clear_scheduled_hook( 'seedprod_fetch_help_docs' );
}

register_deactivation_hook( __FILE__, 'seedprod_pro_deactivate' );



/**
 * Load Plugin
 */
require_once SEEDPROD_PRO_PLUGIN_PATH . 'app/bootstrap.php';
require_once SEEDPROD_PRO_PLUGIN_PATH . 'app/routes.php';
require_once SEEDPROD_PRO_PLUGIN_PATH . 'app/load_controller.php';

// Load Smart Builder frontend functionality (must be loaded early for render_block filter)
if ( file_exists( SEEDPROD_PRO_PLUGIN_PATH . 'sp-smart-builder/smart-builder-frontend.php' ) ) {
	require_once SEEDPROD_PRO_PLUGIN_PATH . 'sp-smart-builder/smart-builder-frontend.php';
}

// Load Smart Builder API endpoints (AJAX handlers)
if ( file_exists( SEEDPROD_PRO_PLUGIN_PATH . 'sp-smart-builder/api-endpoints.php' ) ) {
	require_once SEEDPROD_PRO_PLUGIN_PATH . 'sp-smart-builder/api-endpoints.php';
}

// Load Custom Gutenberg Blocks
if ( file_exists( SEEDPROD_PRO_PLUGIN_PATH . 'blocks/countdown/index.php' ) ) {
	require_once SEEDPROD_PRO_PLUGIN_PATH . 'blocks/countdown/index.php';
}

// Load Smart Builder conversion system
if ( file_exists( SEEDPROD_PRO_PLUGIN_PATH . 'sp-smart-builder/conversion/loader.php' ) ) {
	require_once SEEDPROD_PRO_PLUGIN_PATH . 'sp-smart-builder/conversion/loader.php';
}
/* start-remove-for-free */
require_once SEEDPROD_PRO_PLUGIN_PATH . 'app/functions-posts-block.php';
require_once SEEDPROD_PRO_PLUGIN_PATH . 'app/includes/translations.php';

/**
 * Load Translations
 */
add_action( 'init', 'seedprod_pro_translations' );
function seedprod_pro_translations() {
	$translations = new SEEDPRODTranslations(
		'plugin',
		'seedprod-pro',
		'https://translations.seedprod.com/packages/seedprod-pro/packages.json'
	);
	$translations->init();
}


/* end-remove-for-free */


/**
 * Initialize the new WordPress-native admin pages
 * This runs alongside the existing Vue system for gradual migration
 */
add_action( 'plugins_loaded', 'seedprod_pro_init_native_admin', 15 );
function seedprod_pro_init_native_admin() {
	// Only load in admin
	if ( is_admin() ) {
		require_once SEEDPROD_PRO_PLUGIN_PATH . 'includes/class-seedprod-init.php';
		$seedprod_native = new SeedProd_Pro_Init();
		$seedprod_native->run();
	}
}

/**
 * Register WP-CLI commands
 */
if ( defined( 'WP_CLI' ) && WP_CLI ) {
	require_once SEEDPROD_PRO_PLUGIN_PATH . 'wp-cli-functions.php';
}

/**
 * Maybe Migrate
 */
add_action( 'upgrader_process_complete', 'seedprod_pro_check_for_free_version' );
add_action( 'init', 'seedprod_pro_check_for_free_version' );




